/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions;

import cc.arduino.contributions.VersionHelper;
import cc.arduino.contributions.libraries.ContributedLibrary;
import com.github.zafarkhaja.semver.Version;
import java.util.Comparator;
import java.util.Optional;

public class VersionComparator
implements Comparator<String> {
    public static int compareTo(String a, String b) {
        Optional<Version> versionA = VersionHelper.valueOf(a);
        Optional<Version> versionB = VersionHelper.valueOf(b);
        if (versionA.isPresent() && versionB.isPresent()) {
            return versionA.get().compareTo(versionB.get());
        }
        if (versionA.isPresent()) {
            return 1;
        }
        if (versionB.isPresent()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compare(String a, String b) {
        return VersionComparator.compareTo(a, b);
    }

    public static boolean greaterThan(String a, String b) {
        return VersionComparator.compareTo(a, b) > 0;
    }

    public static String max(String a, String b) {
        return VersionComparator.greaterThan(a, b) ? a : b;
    }

    public static ContributedLibrary max(ContributedLibrary a, ContributedLibrary b) {
        return VersionComparator.greaterThan(a, b) ? a : b;
    }

    public static boolean greaterThan(ContributedLibrary a, ContributedLibrary b) {
        return VersionComparator.greaterThan(a.getParsedVersion(), b.getParsedVersion());
    }
}

